# -*- coding: utf-8 -*-
"""
Created on Mon Feb 17 11:42:48 2025

@author: yasma
"""
#====================
import numpy as np

import pickle

num_exp=100
#====================

#====================
#loading the 100 instances and their confusion matrices for each LR model, obtained through bootstrapping sampling

# 'models0_v3' and 'matrices_conf_test0_v3' belong to LR with Edu input 
# 'models2_v3' and 'matrices_conf_test2_v3' belong to LR with TMT input 
# 'models02_v3' and 'matrices_conf_test02_v3' belong to LR with Edu and TMT inputs 
#==================== 
# To check each LR model change the file name

models = []
with open("models02_v3.pckl", "rb") as f:
    while True:
        try:
            models.append(pickle.load(f))
        except EOFError:
            break
        
with open("matrices_conf_test02_v3.pckl", "rb") as f:
    confusion_matrices_test=pickle.load(f)     
    
#====================
# model results
    
MA_test=np.zeros((2,2))

for i in range(0,num_exp):
    MA_test=MA_test+confusion_matrices_test[i]

mean_acuracy=(MA_test[0][0]+MA_test[1][1])/(np.sum(MA_test))
mean_TPR=MA_test[0][0]/(MA_test[0][0]+MA_test[0][1])
mean_TNR=MA_test[1][1]/(MA_test[1][0]+MA_test[1][1])
mean_PREC_enf=MA_test[0][0]/(MA_test[0][0]+MA_test[1][0])
mean_PREC_sano=MA_test[1][1]/(MA_test[0][1]+MA_test[1][1])
mean_recall_enf=MA_test[0][0]/(MA_test[0][0]+MA_test[0][1])
mean_recall_sano=MA_test[1][1]/(MA_test[1][0]+MA_test[1][1])

class_mean_acuracy=0.5*(mean_recall_enf + mean_recall_sano)


print('\n MC Test:')
print(MA_test)   
print('\n Accuracy: %.3f' % mean_acuracy)
print('\n Accuracy x class: %.3f' % class_mean_acuracy)
print('\n TPR: %.3f' % mean_TPR)
print('\n TNR: %.3f' % mean_TNR)
print('\n Precision enf: %.3f' % mean_PREC_enf)
print('\n Precision sano: %.3f' % mean_PREC_sano)

#====================
# To run the Wald test on the LR model parameters comment/uncomment the next code
# according the the specific model selected in lines 30 and 37.

# #====================
# #====================
# #====================
# # 'models0_v3' and 'matrices_conf_test0_v3' belong to LR with Edu input 
# #====================
# #====================
# #====================

# param0_list=[]
# intercept_list=[]

# for i in range(0,num_exp):
#     param0_list.append(models[i].coef_[0][0])
#     intercept_list.append(models[i].intercept_[0])

# mean_param0=np.mean(param0_list)  
# std_param0=np.std(param0_list) 
# W = np.abs(mean_param0 / np.sqrt(std_param0**2 / num_exp))

# print('Edu param mean = ' + str(mean_param0))
# print('Edu param std = ' + str(std_param0))
# print('|W| = ' + str(W) + '(Results differ from those reported due to approximations in the number of digits after the semicolon. Nonetheless, the conclusions are the same.)')

# mean_intercept=np.mean(intercept_list)  
# std_intercept=np.std(intercept_list) 
# W = np.abs(mean_intercept / np.sqrt(std_intercept**2 / num_exp))

# print('Intercept mean = ' + str(mean_intercept))
# print('Intercept std = ' + str(std_intercept))
# print('|W| = ' + str(W))


# #====================
# #====================
# #====================
# # 'models2_v3' and 'matrices_conf_test2_v3' belong to LR with TMT input 
# #====================
# #====================
# #====================

# param0_list=[]
# intercept_list=[]

# for i in range(0,num_exp):
#     param0_list.append(models[i].coef_[0][0])
#     intercept_list.append(models[i].intercept_[0])

# mean_param0=np.mean(param0_list)  
# std_param0=np.std(param0_list) 
# W = np.abs(mean_param0 / np.sqrt(std_param0**2 / num_exp))

# print('Edu param mean = ' + str(mean_param0))
# print('Edu param std = ' + str(std_param0))
# print('|W| = ' + str(W) + '(Results differ from those reported due to approximations in the number of digits after the semicolon. Nonetheless, the conclusions are the same.)')

# mean_intercept=np.mean(intercept_list)  
# std_intercept=np.std(intercept_list) 
# W = np.abs(mean_intercept / np.sqrt(std_intercept**2 / num_exp))

# print('Intercept mean = ' + str(mean_intercept))
# print('Intercept std = ' + str(std_intercept))
# print('|W| = ' + str(W))

# #====================
# #====================
# #====================
# # 'models02_v3' and 'matrices_conf_test02_v3' belong to LR with Edu and TMT input 
# #====================
# #====================
# #====================

# param0_list=[]
# param1_list=[]
# intercept_list=[]

# for i in range(0,num_exp):
#     param0_list.append(models[i].coef_[0][0])
#     param1_list.append(models[i].coef_[0][1])
#     intercept_list.append(models[i].intercept_[0])
    
# mean_param0=np.mean(param0_list)  
# std_param0=np.std(param0_list) 
# W = np.abs(mean_param0 / np.sqrt(std_param0**2 / num_exp))

# print('Edu param mean = ' + str(mean_param0))
# print('Edu param std = ' + str(std_param0))
# print('|W| = ' + str(W))
    

# mean_param1=np.mean(param1_list)  
# std_param1=np.std(param1_list) 
# W = np.abs(mean_param1 / np.sqrt(std_param1**2 / num_exp))

# print('TMT param mean = ' + str(mean_param1))
# print('TMT param std = ' + str(std_param1))
# print('|W| = ' + str(W))

# mean_intercept=np.mean(intercept_list)  
# std_intercept=np.std(intercept_list) 
# W = np.abs(mean_intercept / np.sqrt(std_intercept**2 / num_exp))

# print('Intercept mean = ' + str(mean_intercept))
# print('Intercept std = ' + str(std_intercept))
# print('|W| = ' + str(W))




